<!DOCTYPE html>
<html lang="en" class="loading">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title>{{ $general->sitename($page_title) }}</title>
    <link rel="icon" href="{{get_image(config('constants.logoIcon.path') .'/favicon.png')}}" type="image/x-icon">
    <link rel="shortcut icon" type="image/png" href="{{ get_image(config('constants.logoIcon.path') .'/favicon.png') }}"/>

    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-touch-fullscreen" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">

    @yield('import-css')
    @stack('style-lib')

    <link href="https://fonts.googleapis.com/css?family=Rubik:300,400,500,700,900%7CMontserrat:300,400,500,600,700,800,900" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/fonts/feather/style.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/fonts/simple-line-icons/style.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/fonts/font-awesome/css/font-awesome.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/vendors/css/perfect-scrollbar.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/vendors/css/prism.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/css/app.css')}}">
    @include('partials.notify-css')
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/css/custom.css')}}">

    @yield('style')
    <link rel="stylesheet" href="{{asset('assets/admin/build/css/intlTelInput.css')}}">
    <style>
        .intl-tel-input {
            position: relative;
            display: inline-block;
            width: 100%;
        !important;
        }
    </style>
</head>
<body data-col="1-column" class=" 1-column  blank-page blank-page">
<!-- ////////////////////////////////////////////////////////////////////////////-->
<div class="wrapper">
    <section id="regestration">
        <div class="container-fluid">
            <div class="row full-height-vh">
                <div class="col-12 d-flex align-items-center justify-content-center gradient-aqua-marine">
                    <div class="card px-4 py-2 box-shadow-2">
                        <div class="card-header text-center">
                            <h4 class="text-uppercase text-bold-400 grey darken-1">@lang('Sign Up your account')</h4>
                        </div>
                        <div class="card-body">
                            <div class="card-block mx-auto">
                                <form action="{{ route('user.register') }}" method="POST" class="account-form" id="recaptchaForm">
                                    @csrf
                                    @isset($reference)
                                        <div class="form-group">
                                            <input type="text" name="referBy" class="form-control form-control-lg" id="referenceBy"
                                                   value="{{$reference}}" placeholder="@lang('Reference BY')" readonly/>
                                        </div>
                                    @endisset
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" class="form-control form-control-lg" id="InputFirstname" name="firstname"
                                                   placeholder="@lang('First Name')" value="{{old('firstname')}}" required="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" class="form-control form-control-lg" id="lastname" name="lastname"
                                                   placeholder="@lang('Last Name')" value="{{old('lastname')}}" required="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" id="exampleInputUsername" name="username" value="{{old('username')}}"
                                                   class="form-control form-control-lg" placeholder="@lang('Username')">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="email" class="form-control form-control-lg" id="email" name="email"
                                                   placeholder="@lang('E-mail Address')" value="{{old('email')}}" required="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="hidden" id="track" name="country_code">
                                            <input type="tel" class="form-control pranto-control form-control-lg" id="phone" name="mobile"
                                                   value="{{old('mobile')}}" placeholder="@lang('Your Contact Number')">
                                        </div>
                                    </div>
                                    <div class="form-group d-none">
                                        <input type="text" name="country" id="country" value="{{old('country')}}"
                                               class="form-control">
                                    </div>

                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="password" name="password" value="{{old('password')}}" class="form-control form-control-lg"
                                                   placeholder="@lang('Password')">
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="password" name="password_confirmation" class="form-control form-control-lg"
                                                   placeholder="@lang('Retype Password')">
                                        </div>
                                    </div>

                                    <div class="form-group text-center">
                                        <input type="submit" id="recaptcha" class="btn btn-danger px-4 py-2 text-uppercase white font-small-4 box-shadow-2 border-0" value="@lang('SIGN UP')">
                                    </div>

                                    <div class="form-group">
                                        @lang("Already have an account yet?")
                                        <a href="{{route('user.login')}}" class="">@lang('Sign In')</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script src="//code.jquery.com/jquery-3.4.1.min.js"></script>
    @php echo recaptcha() @endphp
    <!--Login Page Ends-->
</div>
<!-- ////////////////////////////////////////////////////////////////////////////-->

<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/core/jquery-3.3.1.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/core/popper.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/core/bootstrap.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/perfect-scrollbar.jquery.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/prism.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/jquery.matchHeight-min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/screenfull.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/pace/pace.min.js')}}"></script>
<!-- BEGIN VENDOR JS-->
<!-- BEGIN CONVEX JS-->
<script src="{{asset('assets/templates/minimul_new/app-assets/js/app-sidebar.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/js/notification-sidebar.js')}}"></script>
<!-- END CONVEX JS-->

@include('partials.notify-js')

@yield('load-js')
@yield('script')

<script src="{{ asset('assets/admin/build/js/intlTelInput.js') }}"></script>

<script>
    $('select[name=country]').val("{{ old('country') }}");
</script>

<script>
    $("#phone").on("countrychange", function (e, countryData) {
        // do something with countryData

        var data = $(this).val('+' + countryData.dialCode)
        $('#track').val(data);
        var country = countryData.name;
        var country = country.split('(')[0];
        $('#country').val(country);
    });
    $("#phone").intlTelInput({
        geoIpLookup: function (callback) {
            $.get("https://ipinfo.io", function () {
            }, "jsonp").always(function (resp) {
                var countryCode = (resp && resp.country) ? resp.country : "";
                callback(countryCode);
            });
        },

        // hiddenInput: "full_number",
        initialCountry: "auto",
        utilsScript: "{{asset('assets/admin/build/js/utils.js')}}"
    });
</script>

@stack('js')

@php
    if($plugins[0]->status == 1){
        $appKeyCode = $plugins[0]->shortcode->app_key->value;
        $twakTo = str_replace("{{app_key}}",$appKeyCode,$plugins[0]->script);
        echo $twakTo;
    }
@endphp
</body>
</html>
