<?php $__env->startSection('content'); ?>

    <script>
        function createCountDown(elementId, sec) {
            var tms = sec;
            var x = setInterval(function() {
                var distance = tms*1000;
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                document.getElementById(elementId).innerHTML =days+"d: "+ hours + "h "+ minutes + "m " + seconds + "s ";
                if (distance < 0) {
                    clearInterval(x);
                    document.getElementById(elementId).innerHTML = "<?php echo e(__('COMPLETE')); ?>";
                }
                tms--;
            }, 1000);
        }

    </script>


    <!-- ========User-Panel-Section Starte Here ========-->
    <div class="row">
        <div class="col-12">
            <h2 class="content-header"><?php echo e(__($page_title)); ?></h2>
        </div>
    </div>
    <!--Basic Table Starts-->
    <section id="simple-table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-block table-responsive table-responsive-xl table-responsive-lg table-responsive-md table-responsive-sm">
                            <table class="table table-striped">
                                <thead class="thead-dark">
                                <tr>
                                    <th scope="col"><?php echo app('translator')->get('Plan Name'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Payable Interest'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Period'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Received'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Capital Back'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Invest Amount'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                    <th scope="col" style="width :20%"><?php echo app('translator')->get('Next Payment'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if(count($trans)==0): ?>
                                    <tr>
                                        <td colspan="8" class="text-center"><?php echo app('translator')->get('No Data Available'); ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php $__currentLoopData = $trans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td data-label="<?php echo app('translator')->get('Plan Name'); ?>"><?php echo e(__($data->plan->name)); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Payable Interest'); ?>"><?php echo e(__($general->currency_sym)); ?> <?php echo e(__($data->interest)); ?> / <?php echo e(__($data->time_name)); ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Period'); ?>"><?php if($data->period == '-1'): ?> <span class="badge badge-success"><?php echo app('translator')->get('Life-time'); ?></span>  <?php else: ?> <?php echo e(__($data->period)); ?> <?php echo app('translator')->get('Times'); ?> <?php endif; ?></td>
                                        <td data-label="<?php echo app('translator')->get('Received'); ?>">  <?php echo e(__($data->return_rec_time)); ?> <?php echo app('translator')->get('Times'); ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Capital Back'); ?>"><?php if($data->capital_status == '1'): ?> <span class="badge badge-success"><?php echo app('translator')->get('Yes'); ?></span>  <?php else: ?> <span class="badge badge-warning"><?php echo app('translator')->get('No'); ?></span> <?php endif; ?></td>
                                        <td data-label="<?php echo app('translator')->get('Invest Amount'); ?>">  <?php echo e(__($general->currency_sym)); ?> <?php echo e(__($data->amount)); ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Status'); ?>" style="padding-top:20px">  <?php if($data->status == '1'): ?>  <span class="badge badge-warning"><i class="fas fa-spinner fa-spin"></i> <?php echo app('translator')->get('Running'); ?></span>  <?php else: ?> <span class="badge badge-primary"><?php echo app('translator')->get('Complete'); ?></span> <?php endif; ?> </td>
                                        <td data-label="<?php echo app('translator')->get('Next Payment'); ?>" scope="row" class="font-weight-bold " >  <?php if($data->status == '1'): ?> <p id="counter<?php echo e($data->id); ?>" class="demo countdown timess2 mt-1"></p> <?php else: ?> - <?php endif; ?> </td>
                                    </tr>

                                    <script>createCountDown('counter<?php echo $data->id ?>', <?php echo e(\Carbon\Carbon::parse($data->next_time)->diffInSeconds()); ?>);</script>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <?php echo e($trans->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ========User-Panel-Section Ends Here ========-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make(activeTemplate() .'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ectbest/ecoshop.top/core/resources/views/templates/minimal/user/interest_log.blade.php ENDPATH**/ ?>