

<?php $__env->startSection('panel'); ?>
<div class="row">

    <div class="col-lg-12">
        <div class="card">
            <div class="table-responsive table-responsive-xl">
                <table class="table align-items-center table-light">
                    <thead>
                        <tr>
                            <th scope="col">Email</th>
                            <th scope="col">Joined</th>
                            <th scope="col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $subscribers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscriber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($subscriber->email); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($subscriber->created_at)->diffForHumans()); ?></td>
                            <td><button type="button" class="btn btn-danger removeModalBtn" data-id="<?php echo e($subscriber->id); ?>" data-email="<?php echo e($subscriber->email); ?>"><i class="fa fa-fw fa-trash"></i>Remove</button></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="text-muted text-center" colspan="100%"><?php echo e($empty_message); ?></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="card-footer py-4">
                <nav aria-label="...">
                    <?php echo e($subscribers->links()); ?>

                </nav>
            </div>
        </div>
    </div>
</div>


<div id="removeModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Are you sure want to remove?</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(route('admin.subscriber.remove')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <input type="hidden" name="subscriber">
                    <p><span class="font-weight-bold subscriber-email"></span> will be removed.</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-rounded btn-danger">Remove</button>
                    <button type="button" class="btn btn-dark" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.subscriber.sendEmail')); ?>" class="btn btn-success" ><i class="fa fa-fw fa-paper-plane"></i>Send Email</a> 
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $('.removeModalBtn').on('click', function() {
        $('#removeModal').find('input[name=subscriber]').val($(this).data('id'));
        $('#removeModal').find('.subscriber-email').text($(this).data('email'));
        $('#removeModal').modal('show');
    });

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ectinternational/goldenage.club/resources/views/admin/subscriber/index.blade.php ENDPATH**/ ?>