<?php
    $planCaption = getContent('plan.caption',true);
?>
<?php if($planCaption): ?>
    <?php

        $plans = \App\Plan::where('status', 1)->where('featured', 1)->latest()->get();

    ?>
    <!-- ========Ticket-Section Starts Here ========-->
    <section class="ticket-section  c-shape-wrapper padding">
        <div class="c-shape01" data-paroller-factor="-0.30" data-paroller-factor-lg="0.60"
             data-paroller-type="foreground" data-paroller-direction="horizontal">
            <img src="<?php echo e(asset('assets/images/frontend/animation/circle01.png')); ?>" alt="shapes">
        </div>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="section-header">
                        <h2 class="title"><?php echo e(__(@$planCaption->data_values->title)); ?></h2>
                        <p><?php echo e(__(@$planCaption->data_values->short_details)); ?></p>
                    </div>
                </div>
            </div>

            <div class="row justify-content-center mb-30-none">
                <?php
                    $color = ['bg-1','bg-2','bg-3','bg-4','bg-5','bg-6','bg-7','bg-8'];
                ?>

                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $time_name = \App\TimeSetting::where('time', $data->times)->first();
                    ?>
                    <div class="col-md-6 col-lg-4">
                        <div class="ticket-item <?php echo e($color[$k]); ?>">
                            <h3 class="title"><?php echo e($data->name); ?></h3>
                            <h6 class="sub-title"><?php echo e(__($data->interest)); ?> <?php if($data->interest_status == 1): ?>
                                    % <?php else: ?> <?php echo e(__($general->cur_text)); ?> <?php endif; ?></h6>
                            <ul>
                                <li><?php echo e(__($time_name->name)); ?>

                                    / <?php if($data->lifetime_status == 0): ?> <?php echo e(__($data->repeat_time)); ?> <?php echo app('translator')->get('Times'); ?> <?php else: ?> <?php echo app('translator')->get('Lifetime'); ?> <?php endif; ?></li>
                                <?php if($data->capital_back_status == 1): ?>

                                    <li><span class="badge badge-success"><?php echo app('translator')->get('Capital Will Return Back'); ?></span></li>
                                <?php elseif($data->capital_back_status == 0): ?>
                                    <li><span class="badge badge-warning"><?php echo app('translator')->get('Capital Will Store'); ?></span></li>
                                <?php endif; ?>
                                <li><?php echo app('translator')->get('24/7Support'); ?></li>


                                <?php if($data->fixed_amount == 0): ?>
                                    <li class="plan_min"> <?php echo app('translator')->get('Min.'); ?> <?php echo e(__($general->cur_sym)); ?><?php echo e(__($data->minimum)); ?>

                                        <span><?php echo app('translator')->get('Max:'); ?> <?php echo e(__($general->cur_sym)); ?><?php echo e(__($data->maximum)); ?></span></li>

                                <?php else: ?>
                                    <li class="plan_min"><span><?php echo app('translator')->get('Invest Amount'); ?>
                                            : <?php echo e(__($general->cur_sym)); ?><?php echo e(__($data->maximum)); ?></span></li>

                                <?php endif; ?>
                            </ul>
                            <a href="javascript:void(0)" data-toggle="modal" data-target="#depoModal"
                               data-resource="<?php echo e($data); ?>"
                               class="custom-button custom-button-color investButton"><?php echo app('translator')->get('Invest Now'); ?></a>
                        </div>
                    </div>

                    <?php
                        array_push($color, $color[$k]);
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- ========Ticket-Section Ends Here ========-->
<?php endif; ?>





<?php $__env->startPush('renderModal'); ?>



    <?php
        $wallets = \App\UserWallet::where('user_id', Auth::id())->get();
    ?>
    <!-- Modal -->
    <div class="modal fade" id="depoModal" tabindex="-1" role="dialog" aria-hidden="true">

        <div class="modal-dialog" role="document">
            <div class="modal-content ">
                <div class="modal-header">
                    <strong class="modal-title" id="ModalLabel">

                        <?php if(auth()->guard()->guest()): ?>
                            <?php echo app('translator')->get('At First Sign In your Account'); ?>
                        <?php else: ?>
                            <?php echo app('translator')->get('Confirm to invest on'); ?> <span class="planName"></span>
                        <?php endif; ?>
                    </strong>
                    <a href="javascript:void(0)" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </a>
                </div>
                <form action="<?php echo e(route('user.buy.plan')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <?php if(auth()->guard()->check()): ?>
                        <div class="modal-body">

                            <div class="form-group">
                                <h6 class="text-center investAmountRenge"></h6>

                                <p class="text-center mt-1 interestDetails"></p>
                                <p class="text-center interestValidaty"></p>

                                <div class="form-group">
                                    <strong><?php echo app('translator')->get('Select Wallet'); ?></strong>
                                    <select class="form-control" name="wallet_type">
                                        <?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($data->id); ?>"> <?php echo e(__(str_replace('_',' ',$data->type))); ?>

                                                (<?php echo e(formatter_money($data->balance)); ?> <?php echo e(__($general->currency)); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <input type="hidden" name="plan_id" class="plan_id">


                                <div class="form-group">
                                    <strong><?php echo app('translator')->get('Invest Amount'); ?></strong>
                                    <input type="text" class="form-control fixedAmount" id="fixedAmount" name="amount"
                                           value="<?php echo e(old('amount')); ?>"
                                           onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success "><?php echo app('translator')->get('Yes'); ?></button>
                            <button type="button" class="btn btn-danger btn-sm"
                                    data-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                        </div>
                    <?php endif; ?>

                    <?php if(auth()->guard()->guest()): ?>

                        <div class="modal-footer">
                            <a href="<?php echo e(route('user.login')); ?>" type="button"
                               class="btn btn-success custom-success"><?php echo app('translator')->get('Please, Signin your account at first'); ?></a>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>



<?php $__env->startPush('js'); ?>

    <script>

        (function ($) {
            "use strict";

            $(document).ready(function () {
                $('.investButton').on('click', function () {
                    var data = $(this).data('resource');
                    var symbol = "<?php echo e(__($general->cur_sym)); ?>";
                    var currency = "<?php echo e(__($general->cur_text)); ?>";

                    if (data.fixed_amount == '0') {
                        $('.investAmountRenge').text(`<?php echo app('translator')->get('Invest'); ?>: ${symbol}${data.minimum} - ${symbol}${data.maximum}`);
                        $('.fixedAmount').val('');
                        $('#fixedAmount').attr('readonly', false);

                    } else {
                        $('.investAmountRenge').text(`<?php echo app('translator')->get('Invest'); ?>: ${symbol}${data.fixed_amount}`);
                        $('.fixedAmount').val(data.fixed_amount);

                        $('#fixedAmount').attr('readonly', true);
                    }

                    if (data.interest_status == '1') {
                        $('.interestDetails').html(`<strong> <?php echo app('translator')->get('Interest'); ?>: ${data.interest} % </strong>`);
                    } else {
                        $('.interestDetails').html(`<strong> <?php echo app('translator')->get('Interest'); ?>: ${data.interest} ${currency}  </strong>`);
                    }
                    if (data.lifetime_status == '0') {
                        $('.interestValidaty').html(`<strong>  <?php echo app('translator')->get('Per'); ?> ${data.times} <?php echo app('translator')->get('Hours'); ?> ,  ${data.repeat_time} <?php echo app('translator')->get('Times'); ?></strong>`);
                    } else {
                        $('.interestValidaty').html(`<strong>  <?php echo app('translator')->get('Per'); ?> ${data.times} <?php echo app('translator')->get('Hours'); ?>,  <?php echo app('translator')->get('Lifetime'); ?> </strong>`);
                    }

                    $('.planName').text(data.name);
                    $('.plan_id').val(data.id);

                });
            });
        })(jQuery);

    </script>


<?php $__env->stopPush(); ?>
<?php /**PATH /home/ectinternational/goldenage.club/resources/views/templates/minimal/partials/plan.blade.php ENDPATH**/ ?>