@extends(activeTemplate() .'layouts.user')

@section('content')

    <!-- ========User-Panel-Section Starte Here ========-->
    <div class="row">
        <div class="col-12">
            <h2 class="content-header">{{__($page_title)}}</h2>
        </div>
    </div>

    <section id="simple-table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-block table-responsive table-responsive-xl table-responsive-lg table-responsive-md table-responsive-sm">
                            <table class="table table-striped">
                                <thead class="thead-dark">
                                <tr>
                                    <th scope="col">@lang('Transaction ID')</th>
                                    <th scope="col">@lang('Gateway')</th>
                                    <th scope="col">@lang('Amount')</th>
                                    <th scope="col">@lang('Status')</th>
                                    <th scope="col">@lang('Time')</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if(count($withdraws) >0)
                                    @foreach($withdraws as $k=>$data)
                                        @if($data->method->type == $type)
                                            <tr>
                                                <td data-label="#@lang('Trx')">{{$data->trx}}</td>
                                                <td data-label="@lang('Gateway')">{{ $data->method->name   }}</td>
                                                <td data-label="@lang('Amount')">
                                                    <strong>{{formatter_money($data->amount)}} @if($type == 'money') {{$general->cur_text}} @endif</strong>
                                                </td>
                                                <td data-label="@lang('Status')">
                                                    @if($data->status == 0)
                                                        <span class="badge badge-warning">@lang('Pending')</span>
                                                    @elseif($data->status == 1)
                                                        <span class="badge badge-success">@lang('Completed')</span>
                                                    @elseif($data->status == 2)
                                                        <span class="badge badge-danger">@lang('Rejected')</span>
                                                    @endif

                                                </td>
                                                <td data-label="@lang('Time')">
                                                    <i class="fa fa-calendar"></i> {{date('d M, Y ', strtotime($data->created_at))}}
                                                    <span class="pl-1"></span> {{date('h:i A', strtotime($data->created_at))}}
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="4"> @lang('No results found')!</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>

                            {{$withdraws->links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ========User-Panel-Section Ends Here ========-->
@endsection


@section('load-js')
@stop
@section('script')
@stop
