@extends(activeTemplate() .'layouts.user')

@section('content')

    <!-- ========User-Panel-Section Starte Here ========-->
    <div class="row">
        <div class="col-12">
            <h2 class="content-header">{{__($page_title)}}</h2>
        </div>
    </div>

    <section id="simple-table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-block table-responsive table-responsive-xl table-responsive-lg table-responsive-md table-responsive-sm">
                            <table class="table table-striped">
                                <thead class="thead-dark">
                                <tr>
                                    <th scope="col">@lang('Transaction ID')</th>
                                    <th scope="col">@lang('Amount')</th>
{{--                                    <th scope="col">@lang('Remaining Balance')</th>--}}
                                    <th scope="col">@lang('Details')</th>
                                    <th scope="col">@lang('Date')</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if(count($logs) >0)
                                    @foreach($logs as $k=>$data)
                                        @php $type = $data->withdraw ? $data->withdraw->method->type : 'money' @endphp
                                        <tr>
                                            <td data-label="#@lang('Trx')">
                                                {{$data->trx}} <br>
                                            </td>
                                            <td data-label="@lang('Amount')">
                                                <strong @if($data->type == '+') class="text-success" @else class="text-danger" @endif> {{($data->type == '+') ? '+':'-'}}
                                                    {{formatter_money($data->amount)}}
{{--                                                    @if($type == 'money'){{$general->cur_text}}@endif--}}
                                                </strong>
                                            </td>
{{--                                            <td data-label="@lang('Remaining Balance')">--}}
{{--                                                <strong class="text-info">--}}
{{--                                                    {{formatter_money($data->main_amo)}}--}}
{{--                                                    @if($type == 'money'){{$general->cur_text}}@endif--}}
{{--                                                </strong>--}}
{{--                                            </td>--}}
                                            <td data-label="@lang('Details')">{{$data->title}}</td>
                                            <td data-label="@lang('Date')">{{date('d M, Y', strtotime($data->created_at))}}</td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="5"> @lang('No results found')!</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>

                            {{$logs->links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ========User-Panel-Section Ends Here ========-->
@endsection
