@extends(activeTemplate() .'layouts.user')

@section('content')

    <!-- ========User-Panel-Section Starte Here ========-->
    <div class="row">
        <div class="col-12">
            <h2 class="content-header">{{__($page_title)}}</h2>
        </div>
    </div>

    <div class="row mb-60-80">

        @foreach($authWallets as $k=> $data)
            <div class="col-xl-4 col-lg-6 col-md-6 col-12">
                <div class="card bg-white">
                    <div class="card-body">
                        <div class="card-block pt-2 pb-0">
                            <div class="media">
                                <div class="media-body white text-left">
{{--                                    {{dd($data)}}--}}
                                    <h4 class="font-medium-5 card-title mb-0">{{formatter_money($data->balance)}} {{$general->cur_sym}}</h4>
                                    <span class="grey darken-1">{{__(str_replace('_',' ',strtoupper($data->type)))}}</span>
                                </div>

                                <div class="media-right text-right">
                                    @if($data->type == 'deposit_wallet')
                                        <a href="{{route('user.deposit.history')}}">
                                        <i class> <img src="https://pay.bitcoineco.net/css/btce.png" width="189" height="255" alt="lorem"> </i>
                                        </a>
                                    @elseif($data->type == 'interest_wallet')
                                        <a href="{{route('user.referral')}}">
                                                                   <i class> <img src="https://pay.bitcoineco.net/css/btce.png" width="189" height="255" alt="lorem"> </i>
                                        </a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach

            <div class="col-xl-4 col-lg-6 col-md-6 col-12">
                <div class="card bg-white">
                    <div class="card-body">
                        <div class="card-block pt-2 pb-0">
                            <div class="media">
                                <div class="media-body white text-left">
                                    <h4 class="font-medium-5 card-title mb-0">{{auth()->user()->coins ? auth()->user()->coins->coins: 0}} BTCE</h4>
                                    <span class="grey darken-1">Coins</span>
                                </div>
                                <div class="media-right text-right">
                                    <a href="{{route('user.withdrawLog','coins')}}">
                     <i class> <img src="https://pay.bitcoineco.net/css/btce.png" width="189" height="255" alt="lorem"> </i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-4 col-lg-6 col-md-6 col-12">
                <div class="card bg-white">
                    <div class="card-body">
                        <div class="card-block pt-2 pb-0">
                            <div class="media">
                                <div class="media-body white text-left">
                                    <h4 class="font-medium-5 card-title mb-0">{{auth()->user()->tokens ? auth()->user()->tokens->tokens: 0}} BET</h4>
                                    <span class="grey darken-1">Tokens</span>
                                </div>
                                <div class="media-right text-right">
                                    <a href="{{route('user.withdrawLog','tokens')}}">
                                   <i class> <img src="https://pay.bitcoineco.net/css/btce.png" width="189" height="255" alt="lorem"> </i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-xl-4 col-lg-6 col-md-6 col-12">
            <div class="card bg-white">
                <div class="card-body">
                    <div class="card-block pt-2 pb-0">
                        <div class="media">
                            <div class="media-body white text-left">
                                <h4 class="font-medium-5 card-title mb-0">{{formatter_money($totalInvest)}} {{$general->cur_sym}}</h4>
                                <span class="grey darken-1">@lang('Total Invest')</span>
                            </div>
                            <div class="media-right text-right">
                                <a href="{{route('user.interest.log')}}">
                                 <i class> <img src="https://pay.bitcoineco.net/css/btce.png" width="189" height="255" alt="lorem"> </i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-4 col-lg-6 col-md-6 col-12">
            <div class="card bg-white">
                <div class="card-body">
                    <div class="card-block pt-2 pb-0">
                        <div class="media">
                            <div class="media-body white text-left">
                                <h4 class="font-medium-5 card-title mb-0">{{formatter_money($totalWithdraw)}} {{$general->cur_sym}}</h4>
                                <span class="grey darken-1">@lang("Total Withdraw")</span>
                            </div>
                            <div class="media-right text-right">
                                <a href="{{route('user.withdrawLog','money')}}">
                                    <i class> <img src="https://pay.bitcoineco.net/css/btce.png" width="189" height="255" alt="lorem"> </i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-6 col-md-6 col-12">
            <div class="card bg-white">
                <div class="card-body">
                    <div class="card-block pt-2 pb-0">
                        <div class="media">
                            <div class="media-body white text-left">
                                <h4 class="font-medium-5 card-title mb-0">{{formatter_money($totalDeposit)}} {{$general->cur_sym}}</h4>
                                <span class="grey darken-1">@lang('Total Deposit')</span>
                            </div>
                            <div class="media-right text-right">
                                <a href="{{route('user.deposit.history')}}">
                                    <i class> <img src="https://pay.bitcoineco.net/css/btce.png" width="189" height="255" alt="lorem"> </i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-6 col-md-6 col-12">
            <div class="card bg-white">
                <div class="card-body">
                    <div class="card-block pt-2 pb-0">
                        <div class="media">
                            <div class="media-body white text-left">
                                <h4 class="font-medium-5 card-title mb-0">{{$totalTicket}}</h4>
                                <span class="grey darken-1">@lang('Total Ticket')</span>
                            </div>
                            <div class="media-right text-right">
                                <a href="{{route('user.ticket')}}">
                                  <i class> <img src="https://pay.bitcoineco.net/css/btce.png" width="189" height="255" alt="lorem"> </i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Statistics cards Ends-->

    <!--Line with Area Chart 1 Starts-->
    <div class="row match-height">
        <div class="col-xl-12 col-lg-12 col-12">
            <div class="chart">
                <div class="user-header">
                    <h6 class="title">@lang('Revenue Statistics')</h6>
                </div>
                <div class="chart-scroll m-0">
                    <div class="chart-wrapper m-0">
                        <canvas id="myCharT" width="400" height="160"></canvas>
                    </div>
                </div>
            </div>
{{--            <div class="card">--}}
{{--                <div class="card-header">--}}
{{--                    <div class="card-title-wrap bar-success">--}}
{{--                        <h4 class="card-title">Product Valuation</h4>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--                <div class="card-body">--}}
{{--                    <div class="card-block">--}}
{{--                        <div id="line-chart" class="height-300 lineChart lineChartShadow">--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
        </div>
    </div>

    <!-- ========User-Panel-Section Ends Here ========-->
@endsection


@section('load-js')
    <script src="{{asset('assets/templates/minimul/js/chart.js')}}"></script>
@stop
@section('script')
    <script>
        var ctx = document.getElementById('myCharT').getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: @json($collection['day']),
                datasets: [{
                    label: '# Weekly Revenue',
                    data: @json($collection['trx']),
                    backgroundColor: [
                        'rgba(58, 248, 93, 0.26)',
                        'rgba(54, 162, 235, 0.2)',
                        'rgba(255, 206, 86, 0.2)',
                        'rgba(75, 192, 192, 0.2)',
                        'rgba(153, 102, 255, 0.2)',
                        'rgba(255, 159, 64, 0.2)',
                        'rgba(58, 248, 93, 0.26)'
                    ],
                    borderColor: [
                        'rgba(58, 248, 80, 0.65)',
                        'rgba(54, 162, 235, 1)',
                        'rgba(255, 206, 86, 1)',
                        'rgba(75, 192, 192, 1)',
                        'rgba(153, 102, 255, 1)',
                        'rgba(255, 159, 64, 1)',
                        'rgba(58, 248, 80, 0.65)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true
                        }
                    }]
                }
            }
        });
    </script>
@endsection
