<!DOCTYPE html>
<html lang="en" class="loading">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title>{{ $general->sitename($page_title) }}</title>
    <link rel="icon" href="{{get_image(config('constants.logoIcon.path') .'/favicon.png')}}" type="image/x-icon">
    <link rel="shortcut icon" type="image/png" href="{{ get_image(config('constants.logoIcon.path') .'/favicon.png') }}"/>

    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-touch-fullscreen" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">

    @yield('import-css')
    @stack('style-lib')

    <link href="https://fonts.googleapis.com/css?family=Rubik:300,400,500,700,900%7CMontserrat:300,400,500,600,700,800,900" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/fonts/feather/style.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/fonts/simple-line-icons/style.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/fonts/font-awesome/css/font-awesome.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/vendors/css/perfect-scrollbar.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/vendors/css/prism.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/css/app.css')}}">
    @include('partials.notify-css')
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/css/custom.css')}}">

    @yield('style')
</head>
<body data-col="1-column" class=" 1-column  blank-page blank-page">
<!-- ////////////////////////////////////////////////////////////////////////////-->
<div class="wrapper">
    <section id="login">
        <div class="container-fluid">
            <div class="row full-height-vh">
                <div class="col-12 d-flex align-items-center justify-content-center gradient-aqua-marine">
                    <div class="card px-4 py-2 box-shadow-2 width-400">
                        <div class="card-header text-center">
                            <h4 class="text-uppercase text-bold-400 grey darken-1">Login</h4>
                        </div>
                        <div class="card-body">
                            <div class="card-block">
                                <form action="{{ route('user.login') }}" method="POST"  class="account-form" id="recaptchaForm">
                                    @csrf
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" id="exampleInputUsername"  name="username" value="{{old('username')}}" class="form-control form-control-lg" placeholder="@lang('Username')" >
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="password" name="password" value="{{old('password')}}" class="form-control form-control-lg" placeholder="@lang('Password')">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="custom-control custom-checkbox mb-2 mr-sm-2 mb-sm-0 ml-5">
                                                    <input type="checkbox" class="custom-control-input" id="check02">
                                                    <label class="custom-control-label float-left" for="check02"> @lang('Remember Me')</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="text-center col-md-12">
                                            <input type="submit" id="recaptcha" class="btn btn-danger px-4 py-2 text-uppercase white font-small-4 box-shadow-2 border-0" value="@lang('SIGN IN')">
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="card-footer grey darken-1">
                            <div class="text-center mb-1">Forgot Password? <a href="{{route('user.password.request')}}"><b>@lang('Reset')</b></a></div>
                            <div class="text-center">Don't have an account? <a href="{{route('user.register')}}"><b>@lang('Signup')</b></a></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Login Page Ends-->
</div>
<!-- ////////////////////////////////////////////////////////////////////////////-->

<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/core/jquery-3.3.1.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/core/popper.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/core/bootstrap.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/perfect-scrollbar.jquery.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/prism.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/jquery.matchHeight-min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/screenfull.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/pace/pace.min.js')}}"></script>
<!-- BEGIN VENDOR JS-->
<!-- BEGIN CONVEX JS-->
<script src="{{asset('assets/templates/minimul_new/app-assets/js/app-sidebar.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/js/notification-sidebar.js')}}"></script>
<!-- END CONVEX JS-->

@include('partials.notify-js')

@yield('load-js')
@yield('script')
@stack('js')

@php
    if($plugins[0]->status == 1){
        $appKeyCode = $plugins[0]->shortcode->app_key->value;
        $twakTo = str_replace("{{app_key}}",$appKeyCode,$plugins[0]->script);
        echo $twakTo;
    }
@endphp
</body>
</html>
