@extends(activeTemplate() .'layouts.user')

@section('style')

@stop
@section('content')

    <!-- ========User-Panel-Section Starte Here ========-->
    <div class="row">
        <div class="col-12">
            <h2 class="content-header">{{__($page_title)}}</h2>
        </div>
    </div>

    <section class="mt-4">
        <div class="container user-panel-container">
            <div class="row mb-60-80 justify-content-center">
                <div class="col-md-8">
                        <ul class="list-group text-center">

                            <li class="list-group-item">
                                <img
                                    src="{{ $data->gateway_currency()->methodImage() }}"
                                    style="max-width:100px; max-height:100px; margin:0 auto;"/>
                            </li>

                            <p class="list-group-item">
                                @lang('Amount'):
                                <strong>{{formatter_money($data->amount)}} </strong> {{$general->cur_text}}
                            </p>

{{--                            <p class="list-group-item">--}}
{{--                                @lang('Charge'):--}}
{{--                                <strong>{{formatter_money($data->charge)}}</strong> {{$general->cur_text}}--}}
{{--                            </p>--}}

{{--                            <p class="list-group-item">--}}
{{--                                @lang('Payable'): <strong> {{$data->amount + $data->charge}}</strong> {{$general->cur_text}}--}}
{{--                            </p>--}}

{{--                            <p class="list-group-item">--}}
{{--                                @lang('Conversion Rate'): <strong>1 {{$data->baseCurrency()}}--}}
{{--                                    = {{formatter_money($data->rate)}} {{$general->cur_text}}  </strong>--}}
{{--                            </p>--}}


{{--                            <p class="list-group-item">--}}
{{--                                @lang('In') {{$data->baseCurrency()}}:--}}
{{--                                <strong>{{formatter_money($data->final_amo)}}</strong>--}}
{{--                            </p>--}}


                            @if($data->gateway->crypto==1)
                                <p class="list-group-item">
                                    @lang('Conversion with')
                                    <b> {{ $data->method_currency }}</b> @lang('and final value will Show on next step')
                                </p>
                            @endif
                        </ul>


                    @if($data->method_code == 547)
                        <button id="pay" class="btn btn-custom2 btn-block">@lang('PAY Now')</button>
                    @else
                        <a href="{{route('user.deposit.confirm')}}" class="btn btn-custom2 btn-block">@lang('Pay Now')</a>
                    @endif
                </div>
            </div>
        </div>
    </section>
    <!-- ========User-Panel-Section Ends Here ========-->

    <div id="loading-background">
        <i data-loading-icon="tail-spin" class="w-8 h-8"></i>
    </div>
@endsection


@section('load-js')
@stop


@section('script')
    <script src ="https://give.btcpayx.com/modal/btcpay.js"></script>
    <script>
        const invoiceCreation = {
            "price": "{{formatter_money($data->final_amo)}}",
            "trx": "{{$track}}"
        };

        $('#pay').on('click',function() {
            $(this).html('Loading');
            $('#loading-background').css('display','flex');
            fetch("{{route('user.BtcPayDeposit')}}",{
                responseType: 'json',
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    "X-CSRF-TOKEN": "{{csrf_token()}}"
                },
                // body: invoiceCreation
                body: JSON.stringify(invoiceCreation)
            })
                .then(response => response.json())
                .then(response => {
                    // console.log(response.data.id);
                    let invoiceID = response.data;
                    window.btcpay.showInvoice(invoiceID);
                });
        });

        window.btcpay.onModalWillLeave(function () {
            $('#loading-background').css('display','none');
            $("#pay").html('Pay Now');
            let url = "{{route('user.deposit.history')}}";
            window.location.href = url;

        });


    </script>
@endsection
