<!DOCTYPE html>
<html lang="en" class="loading">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title>{{ $general->sitename($page_title) }}</title>
    <link rel="icon" href="{{get_image(config('constants.logoIcon.path') .'/favicon.png')}}" type="image/x-icon">
    <link rel="shortcut icon" type="image/png" href="{{ get_image(config('constants.logoIcon.path') .'/favicon.png') }}"/>

    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-touch-fullscreen" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">

    @yield('import-css')
    @stack('style-lib')

    <link href="https://fonts.googleapis.com/css?family=Rubik:300,400,500,700,900%7CMontserrat:300,400,500,600,700,800,900" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/fonts/feather/style.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/fonts/simple-line-icons/style.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/fonts/font-awesome/css/font-awesome.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/vendors/css/perfect-scrollbar.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/vendors/css/prism.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/vendors/css/chartist.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/css/app.css')}}">
    @include('partials.notify-css')
    <link rel="stylesheet" type="text/css" href="{{asset('assets/templates/minimul_new/app-assets/css/custom.css')}}">

    @yield('style')
</head>
<body data-col="2-columns" class=" 2-columns ">
<!-- ////////////////////////////////////////////////////////////////////////////-->
<div class="wrapper">

    @include(activeTemplate().'partials.sidebar_user')

    @include(activeTemplate().'partials.header_user')

    <div class="main-panel">
        <div class="main-content">
            <div class="content-wrapper">
                <div class="container-fluid">

                    @yield('content')

                </div>
            </div>
        </div>

        <footer class="footer footer-static footer-light">

        </footer>
    </div>
</div>
<!-- ////////////////////////////////////////////////////////////////////////////-->

@stack('renderModal')

<!-- BEGIN VENDOR JS-->
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/core/jquery-3.3.1.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/core/popper.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/core/bootstrap.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/perfect-scrollbar.jquery.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/prism.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/jquery.matchHeight-min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/screenfull.min.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/pace/pace.min.js')}}"></script>
<!-- BEGIN VENDOR JS-->
<!-- BEGIN PAGE VENDOR JS-->
<script src="{{asset('assets/templates/minimul_new/app-assets/vendors/js/chartist.min.js')}}"></script>
<!-- END PAGE VENDOR JS-->
<!-- BEGIN CONVEX JS-->
<script src="{{asset('assets/templates/minimul_new/app-assets/js/app-sidebar.js')}}"></script>
<script src="{{asset('assets/templates/minimul_new/app-assets/js/notification-sidebar.js')}}"></script>
<!-- END CONVEX JS-->
<!-- BEGIN PAGE LEVEL JS-->
<script src="{{asset('assets/templates/minimul_new/app-assets/js/dashboard-ecommerce.js')}}"></script>
<!-- END PAGE LEVEL JS-->

@include('partials.notify-js')

@yield('load-js')
@yield('script')
@stack('js')

@php
    if($plugins[0]->status == 1){
        $appKeyCode = $plugins[0]->shortcode->app_key->value;
        $twakTo = str_replace("{{app_key}}",$appKeyCode,$plugins[0]->script);
        echo $twakTo;
    }
@endphp
</body>
</html>
